/*****************************************************************************************************/
/* This code was created by Venetia Pliatsika and Jason Mazzatenta and is an implementation of the   */
/* Teiresias algorithm as it appears on the paper Rigoutsos, I, Floratos, A (1998) Combinatorial     */
/* pattern discovery in biological sequences: The TEIRESIAS algorithm. Bioinformatics 14: 55-67.     */
/* Contact us at: https://cm.jefferson.edu/contact-us/                                               */
/*                                                                                                   */
/* Use of these codes is bound by the following terms and conditions:                                */
/*                                                                                                   */
/* Terms of Use:  This code can be freely used for research, academic and other non-profit activities*/
/* (the “Authorized Use”). Commercial use is strictly prohibited.  The code can be copied and        */
/* compiled on any platform for the Authorized Use, but cannot be modified without the written       */
/* permission of the Computational Medicine Center of Thomas Jefferson University                    */
/* https://cm.jefferson.edu                                                                          */
/*                                                                                                   */
/* THE CODE IS PROVIDED “AS IS” WITH NO REPRESENTATIONS OR WARRANTIES OF ANY KIND, EITHER EXPRESSED  */
/* OR IMPLIED. TO THE FULLEST EXTENT PERMISSIBLE PURSUANT TO APPLICABLE LAW. THOMAS JEFFERSON        */
/* UNIVERSITY, AND ITS AFFILIATES, DISCLAIM ALL WARRANTIES, EXPRESS OR IMPLIED, INCLUDING, BUT NOT   */
/* LIMITED TO, THE IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND*/
/* NON-INFRINGEMENT.                                                                                 */
/*                                                                                                   */
/* NEITHER THOMAS JEFFERSON UNIVERSITY NOR ITS AFFILIATES MAKE ANY REPRESENTATION AS TO THE RESULTS  */
/* TO BE OBTAINED FROM USE OF THE CODE.                                                              */
/*****************************************************************************************************/

#ifndef CONFIG_H_
#define CONFIG_H_

#include <string>

// TODO: implement k_switch, diagnostics, uppercase, equivalence_file, max_brackets, and remove_overlaps
struct Config
{
	Config();
	bool run; // execute program
	bool h; // get help (command argument list)(Defaults to true, user must turn it off to not display it)
	unsigned l; // at least this many residues (l <= w)
	unsigned w; // elementary pattern (P) size
	unsigned k; // min support (k <= number of seqs in input file)(has two forms and switch, see k_switch)
	std::string input_file;
	std::string output_file;
	bool k_switch; // switch from min k per sequence to min k in general (found anywhere). Default = false means general
	std::string equivalence_file; // homology list. "" means that there are no homologies to be checked
	int max_brackets; // max number of homologies (default = -1)
	//bool diagnostics; // if true, provides diagnostics for output
	bool offset_report; // if true, reports {seq_id, offset} info for patterns
	//bool uppercase; // if true, ignores any patterns that contain lowercase ASCII characters
	bool scan_only; // perform scan only and report Ps
    int convolution_length; //inactive and set up to be l-1 always
    int max_support; //maximum support of pattern
	//remove_overlaps;
};

// Initialize the command line arguments
Config initialize_cmdline(const int argc, const char *const argv[]);

#endif
